/** @file   sensorcontroller.cpp
 * @brief   Implementation of SensorController - class.
 * @version $Revision: 1.1.1.1 $
 * @author  Tomi Lamminsaari
 */

#include "sensorcontroller.h"
#include "vec2d.h"
#include "warglobals.h"
using namespace eng2d;

namespace WeWantWar {

///
/// Static members, constants and datatypes
/// =======================================




///
/// Constructors, destructor and operators
/// ======================================
/** Constructor
 */
SensorController::SensorController( GameObject* pOwner ) :
  BaseController( pOwner ),
  
  m_scanDir( 0 ),
  m_viewAngle( 256 ),
  m_scannerRotation( 0 ),
  m_senseRange( 400 )
{
}



/** Destructor
 */
SensorController::~SensorController()
{
}




///
/// Public methods
/// ==============

/** Updates this controller
 */
void SensorController::update()
{
  this->reset();
  Vec2D p = WarGlobals::pObjTable->pPlayer->position();
  p -= BaseController::m_pObject->position();
  
  float srange = m_senseRange * m_senseRange;
  if ( p.length2() < srange ) {
    this->shoot() = 1;
  }
}




///
/// Getter methods
/// ==============




///
/// Private or Protected methods
/// ============================

} // end of namespace

/**
 * Version history
 * ===============
 * $Log: sensorcontroller.cpp,v $
 * Revision 1.1.1.1  2006/01/21 23:02:43  lamminsa
 * no message
 *
 * Revision 1.0  2005-11-06 01:15:37+02  lamminsa
 * Initial revision
 *
 */
 
